<?php
/*------------------------------------------------
 * Конвертер YML от prom.ua для для gmc 2020-09-19
 * Copyright © FinBoss 2020
 * finboss.ua@gmail.com 
 *
 * выбор категорий
 *
 * License: Commercial open source software (COSS) 
 *------------------------------------------------
 */

@set_time_limit(0);

error_reporting (E_ALL);

header('Content-Type: text/html; charset=utf-8');

// контроль доступа по IP
$a_allow = false;
if (is_file('.allowed_ip')){
	$a_ips = file('.allowed_ip');
	
	foreach ($a_ips as $a_ip){
		$a_ip = trim($a_ip);
		if (strpos($a_ip, '*') !== false){
			
			// process 127.0.*.*
			
			$remote = explode('.', $_SERVER['REMOTE_ADDR']);
			$a = explode('.', $a_ip);
			
			$true_count = 0;
			for ($i=0;$i<4;$i++){
				switch ($i){
					case 0:
					case 1:
						if ($remote[$i] != $a[$i]){
							break 2;
						}else{
							$true_count++;
						}
						break;
					case 2:
					case 3:
						if ($a[$i] == '*'){
							// пропускаем
							$true_count++;
						}else{
							if ($remote[$i] != $a[$i]){
								break 2;
							}else{
								$true_count++;
							}
						}
						
				}
			}
			if ($true_count == 4){
				$a_allow = true;
				break;
			}
			
		}else{
			if ($_SERVER['REMOTE_ADDR'] == trim($a_ip)){
				$a_allow = true;
				break;
			}
		}
	}
	
}
if ($a_allow === false){
	die('доступ для IP '.$_SERVER['REMOTE_ADDR'].' заблокирован');
}

date_default_timezone_set ('Europe/Kiev');

include_once('converter_prom_to_gmc.cfg.php');

$title = "Конвертер YML от prom.ua в XML для GMC - выбор категорий";
	
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf8" >
<title><?php echo $title?></title>
<script language="javascript" type="text/javascript">
function checkAll( n, fldName ) {
  if (!fldName) {
     fldName = 'cb';
  }
	var f = document.adminForm;
	var c = f.toggle.checked;
	var n2 = 0;
	for (i=0; i < n; i++) {
		cb = eval( 'f.' + fldName + '' + i );
		if (cb) {
			cb.checked = c;
			n2++;
		}
	}
}
</script>
</head>
<body style="font-family:Trebuchet MS; font-size: 10pt;" bgcolor="#f5f8fb">

<table width="100%" bgcolor="#416e98">
<tr valign="middle">
<td><span style="font-size:25px; color:#FFF; font-family:Trebuchet MS"><?php echo $title?></span></td>
<td align="right"><span style="font-size:15px; color:#FFF; font-family:Trebuchet MS"></span></td>
</tr>
</table>

<?php 

	
	
	if (!is_file('input/prom.xml') OR (isset($_GET['mode']) AND $_GET['mode'] == 'reload')){

		// 'Файл input/prom.xml не найден - скачиваем';

		$string = curl_get_contents($site_protocol_select.'://'.$xml_link);
		
		if (strpos($string, 'Error: ') !== false){
			die("Ошибка: не удалось получить данные по ссылке ".$xml_link." ответ = $string ".date(" Y-m-d H:i:s"));
		}else if ($string == ''){
			die("Ошибка: не удалось получить данные по ссылке - получен пустой ответ".$xml_link.date(" Y-m-d H:i:s"));
		}else{
			file_put_contents('input/prom.xml', $string);
			unset($string);
			$data = simplexml_load_file('input/prom.xml');
			if (!is_object ($data)){
				die("Ошибка: не удалось получить данные по ссылке ".$xml_link." ответ см. в файле input/prom.xml ".date(" Y-m-d H:i:s"));
			}
			$size = filesize('input/prom.xml');
		}
	}else{
		
		$size = filesize('input/prom.xml');
		$data = simplexml_load_file('input/prom.xml');
		if (is_object($data)){
			
		}else{
			die ('Файл input/prom.xml содержит ошибки');
			
		}
		
	}
	
	$date = $data->attributes()->date;
	$categories_in_file = $data->shop->categories->category;
	$offers = $data->shop->offers->offer;
	echo "<br/><center>\r\n";
	echo "Испльзуется входной файл, сгенерированный $date <br/>\r\n";
	echo "Размер файла $size <br/>\r\n";
	echo "Всего категорий ".count($categories_in_file)." <br/>\r\n";
	echo "Всего товаров ".count($offers)." <br/><br/>\r\n";
	
	echo "<a href='set_categories.php?mode=reload&token=".time()."'><b>ОБНОВИТЬ</b></a> <br/><br/>\r\n";
	echo "<hr/>\r\n";
	echo "</center>\r\n";

	unset($string);
	unset($data);
	unset($categories_in_file);
	
	if (isset($_GET['category_id'])){
		$show_products = true;
	}else{
		$show_products = false;
	}
	
	// количество в категориях
	$products_in_categories = array();
	foreach ($offers as $item){
		
		$categoryId			= trim((string)$item->categoryId);
		
		if (isset($products_in_categories[$categoryId])){
			$products_in_categories[$categoryId]++;
		}else{
			$products_in_categories[$categoryId] = 1;
		}
		
	}
	
	load_tree();
	asort($tree);
	
	$errors = array();
	
	if (isset($_POST['save'])){
		
		$categories = array();
		if (isset($_POST['category'])){
			foreach ($_POST['category'] as $category_id => $value){
				$categories[] = $category_id;
			}
		}
		
		$saved = array();
		$saved['categories'] = $categories;
		
		file_put_contents('tmp/gmc.json', json_encode($saved));
		
	}
	
	if (isset($_POST['save_product'])){
	
		$category_id = $_POST['category_id'];
		
		$products = array();
		
		foreach ($_POST['product'] as $id => $values){
			
			if ($id != '0'){
				if (isset($_POST['products'][$id])){
					$products[$id]['checked'] = '1';
				}else{
					$products[$id]['checked'] = '0';
				}
				
				$products[$id]['name'] = htmlspecialchars_decode($values['name']);
				$products[$id]['description'] = htmlspecialchars_decode($values['description']);
				$products[$id]['price'] = $values['price'];
				$products[$id]['sale_price'] = $values['sale_price'];
				$products[$id]['quantity'] = $values['quantity'];
				$products[$id]['category'] = $values['category'];
				
				$textarea = $values['attr'];
			
				if (trim($textarea) != ''){
					$attrs = array();
					$strings = explode("\r\n", trim($textarea));
					foreach ($strings as $string){
						if (trim($string) != ''){
							if (strpos($string, '=') !== false){
								list($attr, $value) = explode('=', $string);
								if (trim($attr) != '' AND trim($value) != ''){
									$attrs[trim($attr)] = trim($value);
								}
							}
						}
					}
					$products[$id]['attr'] = $attrs;
				}
			}
		}
		
		file_put_contents("tmp/$category_id.json", json_encode($products));
	
	}
	
	if (isset($_POST['save_cat'])){
		if (isset($_POST['product'])){
			
			if ($_POST['product']['0']['category'] != 0){
				
				$category_id = $_POST['category_id'];
				
				if (is_file("tmp/$category_id.json")){
					$products = json_decode(file_get_contents("tmp/$category_id.json"), true);
				}else{
					$products = array();
				}
				
				$new_category = $_POST['product'][0]['category'];
				
				foreach ($_POST['product'] as $id => $values){
					$products[$id]['category'] = $new_category;
				}
				file_put_contents("tmp/$category_id.json", json_encode($products));
			}
		}
	}
	
	if (is_file('tmp/gmc.json')){
		$saved = json_decode(file_get_contents('tmp/gmc.json'), true);
		$categories = $saved['categories'];
	}else{
		$categories = array();
	}
	
	$gmc_tree = array();
	$total = $total_selected = 0;

	
	if (count($errors) != 0){
		echo '<span style="color:red">';
		echo ('<br/>Ошибки:<br/>');
		foreach ($errors as $string){
			echo ($string.'<br/>');
		}
		echo '</span>';
	}
	
	if (count($errors) > 0){
		$has_errors = true;
	}else{
		$has_errors = false;
	}
?>

<form method="post" name="adminForm">
<center>
<h2>Категории</h2>
<h4>(отметьте выгружаемые категории товаров)</h4>
<table width="100%" border="1" style="border-collapse:collapse;border-color:black;">
<tr>
<th></th>
<th>Категория сайта</th>
<th>Всего<br/>товаров</th>
<th>Выбрано<br/>товаров</th>
</tr>
<?php   
	if (!$show_products){
?>
<tr>
	<td align="left" colspan=4>
		<input type="submit" name="save" value="Сохранить" />
	</td>
</tr>
<?php 
	}else{
?>
<tr>
	<td align="center" colspan=4>
		<a href=set_categories.php>Выбрать категории</a>
	</td>
</tr>
<?php 		
	}

	
	$checkbox_count = 0;
	

	
	
	foreach ($tree as $category_id => $category_name){
		
		// наличие подкатегорий
		
		if (strpos($category_name, '>') === false){
			
			if (!$show_products){
				$checkbox_count++;
			}
			if (in_array($category_id, $categories)){
				$checked = ' checked ';
			}else{
				$checked = '';
			}

?>
<tr><td align=center>
<?php 
			if (!$show_products){
?>
<input type="checkbox" id="cb<?php echo $checkbox_count; ?>" name="category[<?php echo $category_id?>]" value="1" <?php echo $checked?> />
<?php 
			}else{
				if ($checked == ' checked '){
?>
<img src=selected.gif />
<?php 
				}else{
?>
<img src=unselected.gif />
<?php 
				}
			}
?>
</td><td> <span style="font-weight:bold;"><?php echo $category_name." ($category_id)"?></span> </td>
<td align=right><?php products_count($category_id); ?></td>
<td align=center><?php products_selected($category_id); ?></td></tr>
<?php
			show_subcat($tree, $category_name, 1);
		}
	}
	?>

<tr>
	<td align="right" colspan=2> Всего </td>
	<td align="center" > <?php echo $total?> </td>
	<td align="center" > <?php echo $total_selected?> </td>
</tr>
<?php 
	if (!$show_products){
?>

<tr>
	<td align="left" colspan=4>
		<input type="checkbox" name="toggle" class="delete" onclick="checkAll(<?php echo ($checkbox_count+1); ?>)" /> Все выделить/снять выделение
	</td>
</tr>

<tr>
	<td align="left" colspan=4>
		<input type="submit" name="save" value="Сохранить" />
	</td>
</tr>
<?php 
	}else{
?>
<tr>
	<td align="center" colspan=4>
		<a href=set_categories.php>Выбрать категории</a>
	</td>
</tr>
<?php 		
	}
?>
</table>
<br/><br/>
<?php 

	if (isset($_GET['category_id'])){
		
		$category_id = $_GET['category_id'];
		
		echo ('<a name="products"/>');
		echo ('<h3>'.$tree[$category_id].'</h3>');
		echo '<br/>';

		show_products($category_id);
		
	}

?>
</center>
</form>
</body></html>
	
<?php 
//***************************************************************************

// вывод подкатегорий
function show_subcat($tree, $parent_name, $repeat){
	
	global $categories, $checkbox_count, $show_products;
	
	$found = false;
?>

<?php 
	foreach ($tree as $category_id => $category_name_in_file){
		
		// наличие подкатегорий
		if (strpos($category_name_in_file, $parent_name.'>') === 0){
			
			if ($category_name_in_file == $parent_name){
				continue;
			}

			$category_name = str_replace($parent_name.'>', '', $category_name_in_file);
			
			$category_path = explode('>', $category_name);
			
			if (count($category_path) != 1){
				continue;
			}
			
			$current_category = array_shift($category_path);
			
			$found = true;
			
			if (in_array($category_id, $categories)){
				$checked = ' checked ';
			}else{
				$checked = '';
			}
			if (!$show_products){
				$checkbox_count++;
			}

?>
<tr><td align=center>
<?php 
			if (!$show_products){
?>
<input type="checkbox" id="cb<?php echo $checkbox_count; ?>" name="category[<?php echo $category_id?>]" value="1" <?php echo $checked?> />
<?php 
			}else{
				if ($checked == ' checked '){
?>
<img src=selected.gif />
<?php 
				}else{
?>
<img src=unselected.gif />
<?php 
				}
			}
?>
</td>
<td> <?php echo str_repeat(' > ', $repeat).$current_category." ($category_id)" ?></td>
<td align=right><?php products_count($category_id); ?></td>
<td align=center><?php products_selected($category_id); ?></td>
</tr>
<?php 
			show_subcat($tree, $category_name_in_file, $repeat+1);

			
		}else{
			
			if ($found){
				break;
			}
		}
		
	}
?>

<?php 
}


// Обработчик ошибок SQL
function databaseErrorHandler($message, $info)
{
    // Если использовалась @, ничего не делать.
    //if (!error_reporting()) return;
    // Выводим подробную информацию об ошибке.
    echo "SQL Error: $message<br><pre>"; 
    print_r($info);
    echo "</pre>";
    exit();
}

// function value($cat_id){
	
// 	global $gmc_category;
// 	global $auto_generate_cat_id;
	
// 	if (isset($gmc_category[$cat_id])){
// 		echo $gmc_category[$cat_id];
// 	}else{
// 		echo '';
// 	}
// }

function curl_get_contents($url, array $get = array(), array $options = array())
{
	
	$defaults = array(
			CURLOPT_URL => $url. (strpos($url, '?') === FALSE ? '?' : ''). http_build_query($get),
			CURLOPT_HEADER => 0,
			CURLOPT_RETURNTRANSFER => TRUE,
			CURLOPT_FOLLOWLOCATION => 1,
			CURLOPT_TIMEOUT => 300,
			CURLOPT_HTTPHEADER => array('Accept: application/json'),
			CURLOPT_SSL_VERIFYPEER => false
	);
	
	$ch = curl_init();
	curl_setopt_array($ch, ($options + $defaults));
	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.1.2) Gecko/20090729 Firefox/3.5.2 GTB5');
	if(!$result = curl_exec($ch)) {
		trigger_error(curl_error($ch));
		$result = 'Error: '.curl_error($ch);
	}else{
		//echo 'OK';
	}
	curl_close($ch);
	
	return $result;
}


function load_tree(){
	
	global $tree;
	
	$tree1 = $tree1_parent = array();
	
	$xml_string = '';
	
	$handle = @fopen("input/prom.xml", "r");
	if ($handle) {
		// файл найден
	}else{
		die("Ошибка: не найден файл input/prom.xml");
	}
	
	// определение кодировки
	$string = strtolower(fgets($handle));
	if (strpos($string, 'encoding')){
		
		$string = substr($string, strpos($string, 'encoding')+10);
		$in_charset = substr($string, 0, strpos($string, '"'));
		
	}else{
		echo("<br/>Ошибка: не удалось определить кодировку файла");
		echo("<br/>Первая строка: $string");
		die("<br/>Работа завершена аварийно");

	}
	
	$found = false;
	while (!feof($handle)) {
		$buffer = fgets($handle);
		if (strpos($buffer, '<categories>') !== false){
			$xml_string .= '<categories>'."\r\n";
			$found = true;
			break;
		}
	}
	
	if (!$found){
		die("Ошибка: во входном файле не найдена подстрока '<categories>'");
	}
	
	$found = false;
	while (!feof($handle)) {
		$buffer = fgets($handle);
		if (strpos($buffer, '</categories>') !== false){
			$xml_string .= '</categories>'."\r\n";
			$found = true;
			break;
		}else{
			if ($in_charset != 'utf-8'){
				$xml_string .= iconv($in_charset, 'UTF-8', $buffer);
			}else{
				$xml_string .= $buffer;
			}
		}
	}
	
	if (!$found){
		die("Ошибка: во входном файле не найдена подстрока '</categories>'");
	}
	
	fclose($handle);
	
	$input_categories = simplexml_load_string($xml_string);
	
	foreach ($input_categories->category as $category){
		
		$parent_id = 0;
		
		foreach($category->attributes() as $name => $value) {
			
			switch ($name){
				
				case 'id':
					$id = (int)$value;
					break;
					
				case 'parentId':
					$parent_id = (int)$value;
					break;
					
			}
			
		}
		
		$tree1[$id] = trim((string)$category);
		$tree1_parent[$id] = $parent_id;
	}
	
	$not_found = true;
	
	while ($not_found){
		
		$not_found = false;
		
		foreach ($tree1 as $id => $name){
			
			if ($tree1_parent[$id] == 0){
				$tree[$id] = $name;
			}else{
				if (isset($tree[$tree1_parent[$id]])){
					$tree[$id] = $tree[$tree1_parent[$id]].'>'.$name;
				}else{
					$not_found = true;
				}
			}
			
		}
	}
	
}

function products_count($category_id){
	
	global $products_in_categories, $has_errors, $total;
	
	if (isset($products_in_categories[$category_id])){
		echo $products_in_categories[$category_id].($has_errors?'':" <a href=\"set_categories.php?category_id=$category_id#products\" >Выбрать</a>&nbsp;");
		$total += $products_in_categories[$category_id];
	}else{
		echo '';
	}
}

function products_selected($category_id){

	global $total_selected;
	
	if (is_file("tmp/$category_id.json")){
		
		$products = json_decode(file_get_contents("tmp/$category_id.json"), true);
		
		$counter = 0;
		foreach ($products as $product){
			if (isset($product['checked']) AND $product['checked'] == 1){
				$counter++;
			}
		}
		$total_selected += $counter;
		echo $counter;
		
	}else{
		echo '';
	}
	
}

function show_products($category_id){
	
	global $offers, $default_quantity_int, $checkbox_count, $category_table_textarea;
	global $show_photos_bool;

	if (is_file("tmp/$category_id.json")){
		$products = json_decode(file_get_contents("tmp/$category_id.json"), true);
	}else{
		$products = array();
	}
	
	if (trim($category_table_textarea) == ''){
		?>
		<h1 style="color:red;">Ошибка: не задан параметр 'Категории Розетки'</h1>
<?php 
		return;
	}
	
	$category_table = array();
	$category_table[] = 'Выберите категорию';
	$category_table_array = explode('/r/n', $category_table_textarea);
	foreach ($category_table_array as $string){
		if (strpos($string, '>') !== false){
			$cat1_array = explode('>', $string);
			$cat1 = array_pop($cat1_array);
			list($cat1_name, $cat1_id) = explode('(', $cat1);
			$category_table[(int)$cat1_id] = $cat1_name;
		}else{
			if (strpos($string, '(') !== false){
				list($cat1_name, $cat1_id) = explode('(', $string);
				$category_table[(int)$cat1_id] = $cat1_name;
			}
		}
	}
	
	asort($category_table);
	
?>

<input type="hidden" name="category_id" value="<?php  echo $category_id; ?>" />

<h2>Товары</h2>
<h4>(отметьте выгружаемые товары)</h4>
<table width="100%" border="1" style="border-collapse:collapse;border-color:black;">
<tr>
<th rowspan=2></th>
<th rowspan=2>Наименование</th>
<th rowspan=2>Фото</th>
<th rowspan=2>Цена<br/>Старая цена</th>
<th colspan=6>Для Gogle Merchant Center</th>
</tr>
<tr>
<th>Наименование</th>
<th>Описание</th>
<th>Цена<br/><br/>Цена со скидкой</th>
<th>Категория</th>
<th>Количество</th>
<th>Параметры</th>
</tr>
<tr>
	<td align="center" colspan=9>
		<input type="submit" name="save_product" value="Сохранить" />
	</td>
</tr>

<tr>
<td colspan=7 align=right>Установить всем товарам указанную категорию >>></td>
<td align=center><?php select_category($category_table, 0, '0') ?> </td> 
<td align=left colspan=3><input type="submit" name="save_cat" value="Вперед!" /></td>
</tr>
<?php 
	
	foreach ($offers as $item){
		
		$categoryId			= trim((string)$item->categoryId);
		
		if ($categoryId == $category_id){
			
// 			$id = 0;
			$available = $type = '';
			foreach($item->attributes() as $name => $value) {
				
				switch ($name){
					
					case 'id':
						$id = (string)$value;
						break;
						
					case 'available':
						$available = (string)$value;
						break;
						
					case 'type':
						$type = (string)$value;
						break;
				}
			}
			
			$item_name 		= trim((string)$item->name);
			
			$price		= trim((string)$item->price);
			if (isset($item->oldprice)){
				$old_price	   = trim((string)$item->oldprice);
			}else{
				$old_price = '';
			}
			
			if (isset($products[$id]['name'])){
				$name = htmlspecialchars($products[$id]['name']);
			}else{
				$name = '';
			}
			
			if (isset($products[$id]['description'])){
				$description = htmlspecialchars($products[$id]['description']);
			}else{
				$description = '';
			}
			
			if (isset($products[$id]['price']) AND isset($products[$id]['sale_price'])){
				$gmc_price = $products[$id]['price'];
				$gmc_sale_price = $products[$id]['sale_price'];
			}else{
				$gmc_price = $gmc_sale_price = '0';
			}
			
			if (isset($products[$id]['quantity'])){
				$quantity = $products[$id]['quantity'];
			}else{
				$quantity = $default_quantity_int;
			}
			
			if (isset($item->picture[0])){
				foreach ($item->picture as $picture){
					$image = trim((string)$picture);
					break;
				}
			}else{
				if (isset($item->picture)){
					$image = trim((string)$item->picture);
				}
			}
			
			if (isset($products[$id]['checked'])){
				
				if ($products[$id]['checked'] == '1'){
					$checked = ' checked ';
				}else{
					$checked = '';
				}
			}else{
				$checked = '';
			}
			
			if (isset($products[$id]['category'])){
				$gmc_category_id = (int)$products[$id]['category'];
			}else{
				$gmc_category_id = 0;
			}
			
			$atrr_string = '';
			if (isset($products[$id]['attr'])){
				$attrs = $products[$id]['attr'];
				$delimeter = '';
				foreach ($attrs as $attr => $value){
					$atrr_string .= $delimeter.$attr.'='.$value;
					$delimeter = "\r\n";
				}
			}
			
			$checkbox_count++;
			
?>
<tr>
<td><input type="checkbox" id="cb<?php echo $checkbox_count; ?>" name="products[<?php echo $id?>]" value="1" <?php echo $checked?> /></td>
<td> <?php echo $item_name.'<br/>id='.$id; ?> </td>
<td align=center> <?php if ($show_photos_bool=='да'){?><image src="<?php  echo $image ?>" width=100/><?php }?></td>
<td align=center> <?php echo $price.'<br/>'.$old_price ?></td>
<td align="center" valign="middle"><input type="text" name="product[<?php echo $id?>][name]" value="<?php echo $name; ?>" size="25" /><br/><?php echo $name; ?></td>
<td align=center> <textarea name="product[<?php echo $id?>][description]" rows=5 cols=25><?php echo $description; ?></textarea> </td>
<td align=center>
<input type="text" name="product[<?php echo $id?>][price]" value="<?php echo $gmc_price; ?>" size="5" />
<br/><br/>
<input type="text" name="product[<?php echo $id?>][sale_price]" value="<?php echo $gmc_sale_price; ?>" size="5" />
</td>
<td align=center> <?php select_category($category_table, $gmc_category_id, $id) ?> </td>

<td align=center><input type="text" name="product[<?php echo $id?>][quantity]" value="<?php echo $quantity; ?>" size="5" /></td>
<td align="center" valign="middle"><textarea rows=3 name="product[<?php echo $id;?>][attr]"><?php echo $atrr_string ?></textarea></td>
</tr>
<?php 
			
		}
		
	}
	
?>
<tr>
	<td align="left" colspan=10>
		<input type="checkbox" name="toggle" class="delete" onclick="checkAll(<?php echo ($checkbox_count+1); ?>)" /> Все выделить/снять выделение
	</td>
</tr>
<tr>
	<td align="center" colspan=10>
		<input type="submit" name="save_product" value="Сохранить" />
	</td>
</tr>
</table>
<?php 
}

function select_category($category_table, $gmc_category_id, $id){
	
	if ($gmc_category_id == 0 AND $id != 0){
?>
<h3 style="color:red;">не выбрана категория</h3>
<?php 		
	}
	
?>
<select name="product[<?php echo $id?>][category]" size="1">
<?php 

	foreach ($category_table as $category_id => $category_name){

		if ($category_id == $gmc_category_id){
			$selected = 'selected';
		}else{
			$selected = '';
		}
?>
<option value="<?php echo $category_id; ?>" <?php echo $selected; ?>><?php echo "$category_name ($category_id)" ?></option>
<?php 		
	}
?>	
</select>
<?php 	
}